/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.preferences;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.preferences.AptanaPreferencePage;
import com.aptana.ui.preferences.Messages;
import com.aptana.ui.util.SWTUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class TroubleshootingPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Combo debugCombo;
    private BooleanFieldEditor toggleComponents;
    private CheckboxTableViewer categoryViewer;

    public TroubleshootingPreferencePage() {
        super(1);
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, CorePlugin.getDefault().getBundle().getSymbolicName());
        this.setPreferenceStore((IPreferenceStore)preferenceStore);
        this.setDescription(Messages.TroubleshootingPreferencePage_TroubleshootingPageHeader);
    }

    public void createFieldEditors() {
        Composite appearanceComposite = this.getFieldEditorParent();
        Composite group = AptanaPreferencePage.createGroup(appearanceComposite, Messages.TroubleshootingPreferencePage_LBL_DebuggingOutputLevel);
        Composite debugComp = new Composite(group, 0);
        debugComp.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 5).numColumns(2).create());
        debugComp.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label levelLabel = new Label(debugComp, 0);
        levelLabel.setText(Messages.TroubleshootingPreferencePage_LBL_DebugLevel);
        levelLabel.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.debugCombo = new Combo(debugComp, 8);
        this.debugCombo.setItems(new String[]{Messages.TroubleshootingPreferencePage_Level_Errors, Messages.TroubleshootingPreferencePage_Level_Warnings, Messages.TroubleshootingPreferencePage_Level_All});
        this.debugCombo.select(IdeLog.StatusLevel.valueOf((String)this.getPreferenceStore().getString("pref_debug_level")).ordinal());
        final Label currentValue = new Label(debugComp, 16384);
        currentValue.setText(this.getValueLabel(this.debugCombo.getSelectionIndex()));
        currentValue.setFont(SWTUtils.getDefaultSmallFont());
        currentValue.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 0).grab(true, true).create());
        this.debugCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                currentValue.setText(TroubleshootingPreferencePage.this.getValueLabel(TroubleshootingPreferencePage.this.debugCombo.getSelectionIndex()));
            }
        });
        BooleanFieldEditor showHiddenProcesses = new BooleanFieldEditor("show_system_jobs", Messages.TroubleshootingPreferencePage_ShowHiddenProcesses, -1, group);
        this.addField((FieldEditor)showHiddenProcesses);
        this.toggleComponents = new BooleanFieldEditor("pref_enable_component_debugging", Messages.TroubleshootingPreferencePage_DebugSpecificComponents, -1, group);
        this.addField((FieldEditor)this.toggleComponents);
        Composite composite = new Composite(group, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 5).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 0).hint(400, 300).grab(true, true).create());
        Table table = new Table(composite, 2084);
        table.setFont(group.getFont());
        this.categoryViewer = new CheckboxTableViewer(table);
        this.categoryViewer.getControl().setFont(group.getFont());
        this.categoryViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.categoryViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.categoryViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider());
        this.categoryViewer.setComparator(new ViewerComparator());
        Map tItems = EclipseUtil.getTraceableItems();
        Set keys = tItems.keySet();
        Object[] items = keys.toArray(new String[keys.size()]);
        Arrays.sort(items);
        this.categoryViewer.setInput((Object)items);
        this.categoryViewer.setCheckedElements((Object[])EclipseUtil.getCurrentDebuggableComponents());
        this.categoryViewer.getTable().setEnabled(false);
        if (this.getPreferenceStore().getBoolean("pref_enable_component_debugging")) {
            this.categoryViewer.getTable().setEnabled(true);
        }
        Composite buttonComp = new Composite(composite, 0);
        buttonComp.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        buttonComp.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Button selectAllButton = new Button(buttonComp, 2048);
        selectAllButton.setText(Messages.TroubleshootingPreferencePage_SelectAll);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TroubleshootingPreferencePage.this.categoryViewer.setAllChecked(true);
            }
        });
        Button selectNoneButton = new Button(buttonComp, 2048);
        selectNoneButton.setText(Messages.TroubleshootingPreferencePage_SelectNone);
        selectNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TroubleshootingPreferencePage.this.categoryViewer.setAllChecked(false);
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource().equals(this.toggleComponents)) {
            this.categoryViewer.getTable().setEnabled(Boolean.parseBoolean(event.getNewValue().toString()));
        }
    }

    private String getValueLabel(int selection) {
        switch (selection) {
            case 0: {
                return Messages.TroubleshootingPreferencePage_LBL_OnlyError;
            }
            case 1: {
                return Messages.TroubleshootingPreferencePage_LBL_ErrorsAndImportant;
            }
            case 2: {
                return Messages.TroubleshootingPreferencePage_LBL_AllDebuggingInformation;
            }
        }
        return Messages.TroubleshootingPreferencePage_LBL_UnknownLoggingLevel;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.debugCombo.select(this.getPreferenceStore().getDefaultInt("pref_debug_level"));
        this.categoryViewer.setCheckedElements(ArrayUtil.NO_OBJECTS);
        super.performDefaults();
    }

    public boolean performOk() {
        Object[] elements;
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("pref_debug_level", IdeLog.StatusLevel.values()[this.debugCombo.getSelectionIndex()].toString());
        String[] currentOptions = EclipseUtil.getCurrentDebuggableComponents();
        EclipseUtil.setBundleDebugOptions((String[])currentOptions, (boolean)false);
        ArrayList<String> al = new ArrayList<String>();
        Object[] objectArray = elements = this.categoryViewer.getCheckedElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object i = objectArray[n2];
            al.add((String)i);
            ++n2;
        }
        String[] newOptions = al.toArray(new String[al.size()]);
        store.setValue("pref_debug_component_list", StringUtil.join((String)",", (String[])newOptions));
        EclipseUtil.setBundleDebugOptions((String[])newOptions, (boolean)true);
        EclipseUtil.setPlatformDebugging((boolean)this.toggleComponents.getBooleanValue());
        return super.performOk();
    }
}

